TITLE   'Dielectric Cylinder Charged by Beam'		         { exa106.pde }
SELECT     errlim=1e-4     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS
   Lr=2     Lz=1     r0=0.2
   eps0=8.854e-12     epsr     eps=epsr*eps0
   Er=-dr(U)     Ez=-dz(U)     E=-grad(U)     Em=magnitude(E)
   D=eps*E     Dm=magnitude(D)
   rho_v   rho_vg=1e-6*exp(-5*r^2-5*z)		{ Charge density in glass }
EQUATIONS
   div( D)=rho_v
BOUNDARIES
region 'domain'  epsr=1.0   rho_v=0 		{ Air }
   start (0,Lz) natural(U)=0 line to (0,-Lz)
   value(U)=0 line to (Lr,-Lz) to (Lr,Lz) close
region 'glass'  epsr=7.0  rho_v=rho_vg				
   start(0,0) line to (Lr,0)  to (Lr,Lz) to (0,Lz) close
PLOTS
   contour( rho_v)     elevation( rho_v) from (0,-Lz) to (0,Lz)
   contour(U)     vector(E) norm     elevation( Ez) from (0,-Lz) to (0,Lz)
   vector( D) norm     surface( Dm)
END



